import numpy as np
import argparse
import os

def generate_tsp_dataset(num_samples, num_cities, seed=None):
    if seed is not None:
        np.random.seed(seed)

    dataset = np.random.randint(0, 100, size=(num_samples, num_cities, 2))
    return dataset

def main():
    parser = argparse.ArgumentParser(description='Generate TSP Dataset')
    parser.add_argument('--num_samples', type=int, required=True, help='Number of samples to generate')
    parser.add_argument('--num_cities', type=int, required=True, help='Number of cities per sample')
    parser.add_argument('--output', type=str, required=True, help='File path to store the dataset')
    parser.add_argument('--seed', type=int, default=None, help='Random seed')

    args = parser.parse_args()

    dataset = generate_tsp_dataset(args.num_samples, args.num_cities, args.seed)

    np.save(args.output, dataset)
    print(f"Dataset saved to {args.output}")

if __name__ == "__main__":
    main()
